/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.event.LootTableLoadEvent;

public class LootTableStuff {
    private static final List<BiConsumer<LootTableLoadEvent, TableType>> LOOT_INJECTS = new ArrayList<BiConsumer<LootTableLoadEvent, TableType>>();

    public static void init() {
        if (((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectGlobe);
        }
        if (((Boolean)RegistryConfigs.reg.ROPE_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectRope);
        }
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectFlax);
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectBlueBomb);
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectBomb);
        }
        if (((Boolean)RegistryConfigs.reg.SLINGSHOT_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectStasis);
        }
        if (((Boolean)RegistryConfigs.reg.BAMBOO_SPIKES_ENABLED.get()).booleanValue() && ((Boolean)RegistryConfigs.reg.TIPPED_SPIKES_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectSpikes);
        }
    }

    public static void injectLootTables(LootTableLoadEvent event) {
        TableType type;
        ResourceLocation res = event.getName();
        String nameSpace = res.func_110624_b();
        if ((nameSpace.equals("minecraft") || nameSpace.equals("repurposed_structures")) && (type = LootHelper.getType(res.toString())) != TableType.OTHER) {
            LOOT_INJECTS.forEach(i -> i.accept(event, type));
        }
    }

    public static void tryInjectGlobe(LootTableLoadEvent e, TableType type) {
        if (type == TableType.SHIPWRECK) {
            float chance = (float)ServerConfigs.cached.GLOBE_TREASURE_CHANCE;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_globe").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.GLOBE_ITEM.get())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        }
    }

    public static void tryInjectRope(LootTableLoadEvent e, TableType type) {
        if (type == TableType.MINESHAFT) {
            float chance = 0.35f;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_rope").func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)17.0f))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.ROPE_ITEM.get())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        }
    }

    public static void tryInjectFlax(LootTableLoadEvent e, TableType type) {
        float chance;
        float min = 1.0f;
        float max = 3.0f;
        if (type == TableType.MINESHAFT) {
            chance = 0.15f;
        } else if (type == TableType.DUNGEON) {
            chance = 0.23f;
        } else if (type == TableType.SHIPWRECK_STORAGE) {
            chance = 0.2f;
        } else if (type == TableType.PILLAGER) {
            chance = 1.0f;
            min = 2.0f;
            max = 5.0f;
        } else {
            return;
        }
        LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_flax").func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.FLAX_SEEDS_ITEM.get())).func_216086_a(1)).func_216044_b();
        e.getTable().addPool(pool);
    }

    public static void tryInjectBlueBomb(LootTableLoadEvent e, TableType type) {
        float chance;
        if (type == TableType.STRONGHOLD) {
            chance = 0.03f;
        } else if (type == TableType.MINESHAFT) {
            chance = 0.028f;
        } else if (type == TableType.TEMPLE) {
            chance = 0.07f;
        } else if (type == TableType.FORTRESS) {
            chance = 0.035f;
        } else if (type == TableType.DUNGEON) {
            chance = 0.01f;
        } else {
            return;
        }
        LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_blue_bomb").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_BLUE_ITEM.get())).func_216086_a(1)).func_216044_b();
        e.getTable().addPool(pool);
    }

    public static void tryInjectBomb(LootTableLoadEvent e, TableType type) {
        float chance;
        if (type == TableType.STRONGHOLD) {
            chance = 0.25f;
        } else if (type == TableType.MINESHAFT) {
            chance = 0.12f;
        } else if (type == TableType.TEMPLE) {
            chance = 0.1f;
        } else if (type == TableType.FORTRESS) {
            chance = 0.145f;
        } else {
            return;
        }
        LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_bomb").func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_ITEM.get())).func_216086_a(1)).func_216044_b();
        e.getTable().addPool(pool);
    }

    public static void tryInjectSpikes(LootTableLoadEvent e, TableType type) {
        if (type == TableType.TEMPLE) {
            float chance = 0.38f;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_spikes").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.BAMBOO_SPIKES_ITEM.get())).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get())).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), c -> c.func_74778_a("Potion", "minecraft:poison"))))).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.2f, (float)0.9f)))).func_216044_b();
            e.getTable().addPool(pool);
        }
    }

    public static void tryInjectStasis(LootTableLoadEvent e, TableType type) {
        if (type == TableType.END_CITY) {
            float chance = 0.25f;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_stasis").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151134_bR).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), 1)).func_196082_o())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        }
    }

    private static class LootHelper {
        static boolean RS = CompatHandler.repurposed_structures;
        private static final Pattern RS_SHIPWRECK = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/treasure_chest");
        private static final Pattern RS_SHIPWRECK_STORAGE = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/supply_chest");
        private static final Pattern RS_TEMPLE = Pattern.compile("repurposed_structures:chests/temple/\\w*_chest");
        private static final Pattern RS_TEMPLE_DISPENSER = Pattern.compile("repurposed_structures:chests/temple/\\w*_dispenser");

        private LootHelper() {
        }

        public static TableType getType(String name) {
            if (LootHelper.isShipwreck(name)) {
                return TableType.SHIPWRECK;
            }
            if (LootHelper.isShipwreckStorage(name)) {
                return TableType.SHIPWRECK_STORAGE;
            }
            if (LootHelper.isMineshaft(name)) {
                return TableType.MINESHAFT;
            }
            if (LootHelper.isDungeon(name)) {
                return TableType.DUNGEON;
            }
            if (LootHelper.isTemple(name)) {
                return TableType.TEMPLE;
            }
            if (LootHelper.isTempleDispenser(name)) {
                return TableType.TEMPLE_DISPENSER;
            }
            if (LootHelper.isOutpost(name)) {
                return TableType.PILLAGER;
            }
            if (LootHelper.isStronghold(name)) {
                return TableType.STRONGHOLD;
            }
            if (LootHelper.isFortress(name)) {
                return TableType.FORTRESS;
            }
            if (LootHelper.isEndCity(name)) {
                return TableType.END_CITY;
            }
            return TableType.OTHER;
        }

        private static boolean isShipwreck(String s) {
            return s.equals(LootTables.field_204773_u.toString()) || RS && RS_SHIPWRECK.matcher(s).matches();
        }

        private static boolean isShipwreckStorage(String s) {
            return s.equals(LootTables.field_204772_t.toString()) || RS && RS_SHIPWRECK_STORAGE.matcher(s).matches();
        }

        private static boolean isMineshaft(String s) {
            return s.equals(LootTables.field_186424_f.toString()) || RS && s.contains("repurposed_structures:chests/mineshaft");
        }

        private static boolean isOutpost(String s) {
            return s.equals(LootTables.field_215813_K.toString()) || RS && s.contains("repurposed_structures:chests/outpost");
        }

        private static boolean isDungeon(String s) {
            return s.equals(LootTables.field_186422_d.toString()) || RS && s.contains("repurposed_structures:chests/dungeon");
        }

        private static boolean isTemple(String s) {
            return s.equals(LootTables.field_186430_l.toString()) || RS && RS_TEMPLE.matcher(s).matches();
        }

        private static boolean isTempleDispenser(String s) {
            return s.equals(LootTables.field_186430_l.toString()) || RS && RS_TEMPLE_DISPENSER.matcher(s).matches();
        }

        private static boolean isStronghold(String s) {
            return s.equals(LootTables.field_186427_i.toString()) || RS && s.contains("repurposed_structures:chests/stronghold/nether_storage_room");
        }

        private static boolean isFortress(String s) {
            return s.equals(LootTables.field_186425_g.toString()) || RS && s.contains("repurposed_structures:chests/fortress");
        }

        private static boolean isEndCity(String s) {
            return s.equals(LootTables.field_186421_c.toString());
        }
    }

    public static enum TableType {
        OTHER,
        MINESHAFT,
        SHIPWRECK,
        PILLAGER,
        DUNGEON,
        PYRAMID,
        STRONGHOLD,
        TEMPLE,
        TEMPLE_DISPENSER,
        IGLOO,
        MANSION,
        FORTRESS,
        BASTION,
        RUIN,
        SHIPWRECK_STORAGE,
        END_CITY;

    }
}

